define(['angular', 'app'], function (angular, app) {
    "use strict";

    app.service('GoalGraphService', function($filter) {

        var service = {};

        service.chartConfig = {
            options: {
                chart: {
                    type: 'solidgauge',
                    height: 200,
                    width: 216,
                    reflow: false,
					pinchType: false
                },
                colors: ['#124664', '#8d4653', '#8085e8', '#e4d354', '#f15c80', '#8085e9', '#f7a35c', '#90ed7d',
                    '#434348', '#7cb5ec', '#91e8e1'],
                pane: {
                    center: ['50%', '85%'],
                    size: '140%',
                    startAngle: -90,
                    endAngle: 90,
                    background: {
                        backgroundColor:'#EEE',
                        innerRadius: '60%',
                        outerRadius: '100%',
                        shape: 'arc'
                    }
                },
                tooltip: {
                    enabled: false,
					crosshairs: false,
					followTouchMove: false,
					followPointer: false
                },
                plotOptions: {
                    solidgauge: {
                        dataLabels: {
                            y: (window.innerWidth < 768) ? 90 :
                                navigator.userAgent.match(/windows/i) ? 65 : 60,
                            borderWidth: 0,
                            useHTML: true
                        },
                        wrap: false
                    },
                    series: {
						enableMouseTracking: false
                    }
                },
                rangeSelector : {
                	enabled: false
                }
            },
            useHighStocks: true,
            credits: { enabled: false },
            loading: false,
            title: {text: ''}
        };

        service.getGraphConfig = function(data) {

            var legacyconv = data;
            legacyconv = '{"data": {"target":{"minutes":"0","steps":"0","miles":"0"},"progress":{"minutes":"0","steps":"0","miles":"0"}}}';
            data = JSON.parse(legacyconv);
            data.target.minutes = legacyconv.component[0].valueQuantity.value;
            data.target.miles = legacyconv.component[0].valueQuantity.value;
            data.target.steps = legacyconv.extension[1].valueString;

            var graphConfig = {
                minutes: angular.copy(service.chartConfig),
                steps:   angular.copy(service.chartConfig),
                miles:   angular.copy(service.chartConfig)
            };

            graphConfig.minutes.yAxis = getYaxisConfig('minutes', data);
            graphConfig.steps.yAxis   = getYaxisConfig('steps', data);
            graphConfig.miles.yAxis   = getYaxisConfig('miles', data);

            graphConfig.minutes.series = getSeriesConfig('minutes', data);
            graphConfig.steps.series   = getSeriesConfig('steps', data);
            graphConfig.miles.series   = getSeriesConfig('miles', data);


            return graphConfig;
        };

        var getYaxisConfig = function(item, data) {
            var legacyconv = data;
            legacyconv = '{"data": {"target":{"minutes":"0","steps":"0","miles":"0"},"progress":{"minutes":"0","steps":"0","miles":"0"}}}';
            data = JSON.parse(legacyconv);
            data.target.minutes = legacyconv.component[0].valueQuantity.value;
            data.target.miles = legacyconv.component[0].valueQuantity.value;
            data.target.steps = legacyconv.extension[1].valueString;

            return {
                currentMin: 0,
                currentMax: data.target && data.target[item] ? data.target[item] :
                   (data.progress && data.progress[item]) ? data.progress[item] * 4 : 50000,

                labels: {enabled: false},
                lineWidth: 0,
                minorTickInterval: null,
                tickWidth: 0,
                stops: [
                    [0.1, '#124664'], // red
                    [0.5, '#124664'], // yellow
                    [0.9, '#124664'] // green
                ]
            };
        };

        var getSeriesConfig = function(item, data) {



            var initCapItem = initCap(item),
                windows = navigator.userAgent.match(/windows/i),
                numDecimals = item === 'miles' ? 1 : 0,


                hasTarget = data.target && data.target[item],

                hasProgress = data.progress && data.progress[item],









                formatNumber = function(item, numDecimals) {return $filter('number')(item, numDecimals);},
                
                progressString = hasTarget ? (hasProgress ? formatNumber(data.progress[item], numDecimals) : 0)
                    + '<br/>' + item : 'No<br/>' + initCapItem + '<br/>Goal',
                
                goalStr = (data.target && (data.target[item] != null)) ? 'Goal:&nbsp; ' +
                    formatNumber(data.target[item], numDecimals) + ' ' + item : 'Use Trophy Icon to Set',
                goalString = '<div>' + goalStr + '</div>',
                
                progressVal = (data.progress && hasTarget) ? 
                    (data.progress[item] > data.target[item] ? data.target[item] : data.progress[item]) : 0,
                
                remainingStr = hasTarget ? '&nbsp;&nbsp;&nbsp;'
                    + formatNumber(data.target[item] - progressVal, numDecimals) + ' left' : '&nbsp;&nbsp;',
                remainingString = '<div class="remaining-value">' + remainingStr + '</div>';
            
                if (hasTarget && !windows) {progressString += '<br/>&nbsp;';}
                if (!hasTarget && windows) {remainingString = '';}

                var format = '<span style="font-size: 15px;line-height:15px;padding-bottom:3px;">'
                    + '<span style="color:#124664">' + progressString + '</span>'                
                    + remainingString
                    + goalString
                    + '</span>';

            return [{
                name: item,
                data: [progressVal],
                dataLabels: {format: format}
            }];

            function initCap(word) {
                return word.substring(0,1).toUpperCase() + word.substring(1,word.length).toLowerCase();
            }
        };

        return service;
    });
});